// 2003/03/19 WindowPositionSetting.cs
// Copyright (C) Ortana<ortaclient@hotmail.com>
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

using System;
using System.Xml; 
using System.Drawing; 
using System.IO;
using System.Windows.Forms;

namespace NTF.DOC
{

	/// <summary>
	/// EBhËʒuƃTCYۑB
	/// </summary>
	internal class WindowPositionSetting
	{
		public WindowPositionSetting()
		{
		}


		/// <summary>
		/// EBhẼTCYƈʒuۑ
		/// </summary>
		/// <param name="form">ʒuۑtH[</param>
		/// <param name="windowName">EBhE̖O</param>
		public static void Save(Form form,string windowName)
		{
			if( form.WindowState != FormWindowState.Maximized )
			{
				form.WindowState = FormWindowState.Normal;
			}
			Save(form.Location , form.Size ,windowName);
		}


		/// <summary>
		/// EBhẼTCYƈʒuۑ
		/// </summary>
		/// <param name="_position"> this.Locationn</param>
		/// <param name="_size">this.Sizen</param>
		/// <param name="windowName">KȃEBhE</param>
		public static void Save(Point _position , Size _size ,string windowName)
		{
			try  
			{ 
				using(FileStream stream  = new FileStream(Application.StartupPath + "\\Data\\" + windowName +"PositonConfig.xml" , FileMode.Create ,FileAccess.Write ))
				{
					XmlTextWriter writer = new XmlTextWriter( stream , System.Text.Encoding.UTF8 ); 
					writer.Formatting = Formatting.Indented; 
					writer.Indentation = 2; 

					writer.WriteStartElement("configuration"); 

					Point position = _position;
					try
					{
						if( position.X < 0 || position.Y < 0 )
						{
							throw new System.ApplicationException();
						}
						writer.WriteStartElement("position"); 

						writer.WriteStartElement("x"); 
						writer.WriteString( position.X.ToString() ); 
						writer.WriteEndElement(); 

						writer.WriteStartElement("y"); 
						writer.WriteString( position.Y.ToString() ); 
						writer.WriteEndElement(); 

						writer.WriteEndElement();
						
					}
					catch(System.Exception err)
					{
						System.Diagnostics.Debug.WriteLine(err);
					}


					//TCY
					Size size = _size; 
					writer.WriteStartElement("size"); 

					writer.WriteStartElement("width"); 
					writer.WriteString( size.Width.ToString() ); 
					writer.WriteEndElement(); 

					writer.WriteStartElement("height"); 
					writer.WriteString( size.Height.ToString() ); 
					writer.WriteEndElement(); 

					writer.WriteEndElement();

					writer.WriteEndElement();
					writer.Close();
				}
			}
			catch(System.Exception error)
			{
				System.Diagnostics.Debug.WriteLine(error);
			}
		}

		public static Rectangle Load(string windowName)
		{
			int x = 0; 
			int y = 0; 
			int width = 0; 
			int height = 0; 
			try 
			{ 
				using(FileStream stream  = new FileStream(Application.StartupPath + "\\Data\\" + windowName +"PositonConfig.xml" , FileMode.Open ,FileAccess.Read ))
				{
					XmlTextReader reader = new XmlTextReader( stream ); 



					while ( reader.Read() ) 
					{ 
						if (reader.NodeType != XmlNodeType.Element) 
						{ 
							continue; 
						} 

						switch (reader.Name) 
						{ 
							case "x": 
								reader.Read(); 
								x = Convert.ToInt32(reader.Value); 
								break; 

							case "y": 
								reader.Read(); 
								y = Convert.ToInt32(reader.Value); 
								break; 

							case "width": 
								reader.Read(); 
								width = Convert.ToInt32(reader.Value); 
								break; 

							case "height": 
								reader.Read(); 
								height = Convert.ToInt32(reader.Value); 
								break; 
						} 

					
					} 
				}
			} 
			catch(System.Exception error)
			{
				System.Diagnostics.Debug.WriteLine(error);
			}

			bool positionErr = false;

			Screen[] screen =  Screen.AllScreens;

			int screenWidth = 0;
			for( int i = 0 ; i < screen.Length ; i++ )
			{
				screenWidth += screen[i].WorkingArea.Width;
				if( y >  screen[i].WorkingArea.Height )
				{
					positionErr = true;
					System.Diagnostics.Debug.WriteLine(" y >  screen[i].WorkingArea.Height Assert y =" + y.ToString());
				}
			}

			if( x > screenWidth ){ positionErr = true;}

			if(x < 0 || y < 0 )
			{
				positionErr = true;
				System.Diagnostics.Debug.WriteLine("(x < 0 || y < 0 Assert x = " + x.ToString() + "y" + y.ToString());

			}

			if( positionErr )
			{
				x = y = 0;
			}

			return new Rectangle( new Point(x, y), new Size(width, height) ); 
		}

		
	}
}
